// Template linked list node
template <class T>
struct Listnode {
	T data;
	Listnode<T> *next;
};

// Template linked list class
template <class T>
class List {
public:
	operator T() { return get(); };
	T operator ->() { return get(); };
	T get();
	T getfirst();
	T takefirst();
	void operator++();
	void rewind();
	void add(T data);
	void addend(T data);
	void remove(T data);
	int at_end();
	int is_empty();
	int get_count();
	List();
	~List();
private:
	Listnode<T> *head;
	Listnode<T> *pos;
	Listnode<T> **tailp;
	int count;
};

// Template linked list interface class
template <class T>
class ListEx {
public:
	operator T() { return (T)TheList.get(); }
	T operator ->() { return operator T(); }
	T get() { return (T)TheList.get(); }
	T getfirst() { return (T)TheList.getfirst(); }
	T takefirst() { return (T)TheList.takefirst(); }
	void operator++() {TheList.operator++();}
	void rewind() { TheList.rewind(); }
	void add(T data) { TheList.add((void *)data); }
	void addend(T data) { TheList.addend((void *)data); }
	void remove(T data) { TheList.remove((void *)data); }
	int at_end() { return TheList.at_end(); }
	int is_empty() { return TheList.is_empty(); }
	int get_count() { return TheList.get_count(); }
private:
	List<void *> TheList;
};

#if 0
// Template linked list node (new)
template <class T>
struct LinkedListNode {
	T data;
	LinkedListNode<T> *next;
};

// Template linked list class (new)
template <class T>
class LinkedList {
public:
	LinkedList(void);
	~LinkedList(void);
	operator T(void);
	T operator ->(void) { return get(); }
	T get(void);
	T getfirst(void);
	T takefirst(void);
	T getlast(void);
	T takelast(void);
	void operator++(void);
	void rewind(void);
	void add(T data);
	void addend(T data);
	void remove(T data);
	void clear(void);
	int at_end(void);
	int is_empty(void);
	int get_count(void);
private:
	LinkedListNode<T> *head, **tailp, *pos;
	int count;
};
#endif

template <class T>
class LList {
public:
	void Add(T data);
	T Get(int index);
	void Remove(int index);
	void Flush(void);
	int Count(void);
private:
	ListEx<T> TheList;
};